function test_gui_position

param = getstyleparam;
marg = 4;
% Necessary additions to param
param.parent.leftmargin = 4;
param.parent.rightmargin = 4;
param.parent.topmargin = 4;
param.parent.botmargin = 4;
param.parent.xstretch = 0;
param.parent.ystretch = 0;

param.spacing.min_interline = 3;
param.spacing.hdefault = 4;
param.spacing.default = 4;

%param.axes.style.Units = 'pixels';
%param.axes.style = rmfield(param.axes.style,{'OuterPosition','ActivePositionProperty'})
%keyboard
fig = figure;


%%%%%%%%%%%%%%% Create all UI Controls %%%%%%%%%%%%%%%%%%%%%%%%%%
b1 = uipush('button1');
b2 = uipush('button2');
b3 = uipush('button3');
b4 = uipush('button4');
pwid = 400;
pht = 100;
p1 = uipanel('Units','pixels','Position',[1,1,pwid,pht]);
img_ax = axes('Parent',p1,'ActivePositionProperty','OuterPosition','Units','pixels');

%%%%%%%%%%%%%%%%%%%% Categorize all UI Controls %%%%%%%%%%%%%%%%%%%%%%%%
button_h = [b1,b2,b3,b4];
panel_h = [p1];
axes_h = [img_ax];
%%%%%%%%%%%%%%%%%%%%%%%% Style all UI controls %%%%%%%%%%%%%%%%%%%%%%%%%%
styleui({button_h,panel_h,axes_h},param,{'button','panel','axes'});
%%%%%%%%%%%%%%%%%%% Size all UI Controls %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sizeui({button_h,panel_h},param,{'button','panel'});
%%%%%%%%%%%%%%%%%%%% Define GUI Layout %%%%%%%%%%%%%%%%%%%%%%%%%%%%
p1_layout = {
    {'parent',p1,'xstretchfactor',1,'ystretchfactor',2};
    {img_ax};
    };
    
layout = {
    {'ghost',b1,b1,'ghost',b1};
    {'ghost',b1,b1,'ghost',b2};
    {b3,b4};
    {p1_layout};
%    {'vrubber:1'};
    };

% panel_layout = {
%     {'parent',p1};
%     {b3,'space:10',b4,'space:100'};
%     };
% layout = {
%     {'parent',fig};
%     {b1};
%     {'center',panel_layout,'vmidalign',b2};
%     };


% layout = {
%     {'parent',fig};
%     {'vrubber:1'};
%     {'center',b1,'settab1'};
%     {'vrubber:1','vspace:100','tab1','vtopalign',b2,'vmidalign',b3,'vbotalign',b4};
%     {'vrubber:1'};
%     };
%%%%%%%%%%%%%%%%%%%% Position all UI Controls %%%%%%%%%%%%%%%%%%%%%%%%%%%%
gui_position(layout,param);
%%%%%%%%%%%%%%%%%%%%% Set up output %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(fig,'ResizeFcn',{@gui_position_wrapper,layout,param});
%set(p1, 'ResizeFcn',{@maximize_axis,img_ax,'axis_on'});